/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FilesDialog
extends JDialog
implements ActionListener,
WindowListener,
ItemListener,
KeyListener {
    private JPanel ctrlPanel_;
    private JPanel btnPanel_;
    private JLabel[] labels_;
    private JCheckBox[] checkBoxes_;
    private JTextField[] fileNames_;
    private JButton[] browseButtons_;
    private JLabel lblWebOutPath_;
    private JTextField tfWebOutPath_;
    private JButton btnWebOutPath_;
    private JButton btnSave_;
    private JButton btnCancel_;
    private static final int FILE_ROM = 0;
    private static final int FILE_INT = 1;
    private static final int FILE_WEB = 2;
    private static final int NUM_FILES = 3;
    private static final String[] FILE_NAME_PROPS = new String[]{"firmware", "intFirmware", "webIn"};
    private static final String[] FILE_PROPS_EN = new String[]{"isFirmwareEnabled", "isIntFirmwareEn", "isWebContentEnabled"};
    public static final String BTN_ACT_CLOSE_DLG = "FileDialog_ActClose";

    public FilesDialog(Frame frame, String string) {
        super(frame, string, true);
        this.populateDialog();
        this.centerWindow();
        this.addWindowListener(this);
        this.addKeyListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.btnSave_.getActionCommand().equals(string)) {
            for (int i = 0; i < 3; ++i) {
                SetupProperties.getInst().setProperty(FILE_NAME_PROPS[i], this.fileNames_[i].getText());
                String string2 = this.checkBoxes_[i].isSelected() ? "true" : "false";
                SetupProperties.getInst().setProperty(FILE_PROPS_EN[i], string2);
            }
            SetupProperties.getInst().setProperty("webOutDir", this.tfWebOutPath_.getText());
            this.dispose();
        } else if (BTN_ACT_CLOSE_DLG.equals(string)) {
            this.dispose();
        } else if (this.browseButtons_[0].getActionCommand().equals(string)) {
            this.showLoadFileDialog(0);
        } else if (this.browseButtons_[1].getActionCommand().equals(string)) {
            this.showLoadFileDialog(1);
        } else if (this.browseButtons_[2].getActionCommand().equals(string)) {
            this.showLoadFileDialog(2);
        } else if (this.btnWebOutPath_.getActionCommand().equals(string)) {
            this.showLoadPathDialog();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.fireEvtMBClose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.fireEvtMBClose();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.checkBoxes_[0]) {
            this.fileNames_[0].setEnabled(itemEvent.getStateChange() == 1);
        }
        if (itemSelectable == this.checkBoxes_[1]) {
            this.fileNames_[1].setEnabled(itemEvent.getStateChange() == 1);
        } else if (itemSelectable == this.checkBoxes_[2]) {
            this.fileNames_[2].setEnabled(itemEvent.getStateChange() == 1);
            this.tfWebOutPath_.setEnabled(itemEvent.getStateChange() == 1);
        }
    }

    protected void populateDialog() {
        int n;
        this.labels_ = new JLabel[3];
        this.checkBoxes_ = new JCheckBox[3];
        this.fileNames_ = new JTextField[3];
        this.browseButtons_ = new JButton[3];
        this.labels_[0] = new JLabel("Firmware:");
        this.labels_[1] = new JLabel("Intermediate:");
        this.labels_[2] = new JLabel("Web IN:");
        this.lblWebOutPath_ = new JLabel("Web OUT:");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.ctrlPanel_ = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        for (n = 0; n < 3; ++n) {
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            this.ctrlPanel_.add((Component)this.labels_[n], gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.1;
            this.checkBoxes_[n] = new JCheckBox("", false);
            this.checkBoxes_[n].addItemListener(this);
            this.ctrlPanel_.add((Component)this.checkBoxes_[n], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            this.fileNames_[n] = new JTextField(40);
            this.fileNames_[n].setEnabled(false);
            this.ctrlPanel_.add((Component)this.fileNames_[n], gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.weightx = 1.0;
            this.browseButtons_[n] = new JButton("Browse...");
            this.browseButtons_[n].setActionCommand("btnBrowse_Click" + n);
            this.browseButtons_[n].addActionListener(this);
            this.ctrlPanel_.add((Component)this.browseButtons_[n], gridBagConstraints);
        }
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        this.ctrlPanel_.add((Component)this.lblWebOutPath_, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        this.tfWebOutPath_ = new JTextField(40);
        this.tfWebOutPath_.setEnabled(false);
        this.ctrlPanel_.add((Component)this.tfWebOutPath_, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 1.0;
        this.btnWebOutPath_ = new JButton("Browse...");
        this.btnWebOutPath_.setActionCommand("btnWebOutPath_Click");
        this.btnWebOutPath_.addActionListener(this);
        this.ctrlPanel_.add((Component)this.btnWebOutPath_, gridBagConstraints);
        this.initFileControls(0);
        this.initFileControls(1);
        n = this.initFileControls(2) ? 1 : 0;
        String string = SetupProperties.getInst().getProperty("webOutDir");
        this.tfWebOutPath_.setText(string);
        this.tfWebOutPath_.setEnabled(n != 0);
        this.btnPanel_ = new JPanel();
        this.btnSave_ = new JButton("Save");
        this.btnSave_.setActionCommand("btnSave_Click");
        this.btnSave_.addActionListener(this);
        this.btnPanel_.add(this.btnSave_);
        this.btnCancel_ = new JButton("Cancel");
        this.btnCancel_.setActionCommand(BTN_ACT_CLOSE_DLG);
        this.btnCancel_.addActionListener(this);
        this.btnPanel_.add(this.btnCancel_);
        this.setLayout(new BorderLayout(5, 5));
        this.add("Center", this.ctrlPanel_);
        this.add("South", this.btnPanel_);
        this.pack();
    }

    protected void centerWindow() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.width < this.getSize().width) {
            this.setSize(dimension.width, this.getSize().height);
        }
        if (dimension.height < this.getSize().height) {
            this.setSize(this.getSize().width, dimension.height);
        }
        int n = (dimension.width - this.getSize().width) / 2;
        int n2 = (dimension.height - this.getSize().height) / 2;
        this.setLocation(n, n2);
    }

    private void fireEvtMBClose() {
        this.actionPerformed(new ActionEvent(this, 1001, BTN_ACT_CLOSE_DLG));
    }

    private boolean initFileControls(int n) {
        String string = SetupProperties.getInst().getProperty(FILE_NAME_PROPS[n]);
        boolean bl = false;
        if (string.length() > 0) {
            bl = SetupProperties.getInst().getProperty(FILE_PROPS_EN[n]).equals("true");
        }
        this.fileNames_[n].setText(string);
        this.fileNames_[n].setEnabled(bl);
        this.checkBoxes_[n].setSelected(bl);
        return bl;
    }

    private void showLoadFileDialog(int n) {
        try {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileSelectionMode(2);
            String string = this.fileNames_[n].getText();
            if (string.length() > 0) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
            if (n == 0) {
                jFileChooser.setDialogTitle("Select XPORT Firmware");
                jFileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.getName().toLowerCase().endsWith(".rom") || file.isDirectory();
                    }

                    public String getDescription() {
                        return "XPORT Firmware (.rom)";
                    }
                });
            } else if (n == 1) {
                jFileChooser.setDialogTitle("Select Intermediate Firmware");
                jFileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.getName().toLowerCase().endsWith(".rom") || file.isDirectory();
                    }

                    public String getDescription() {
                        return "Intermediate Firmware (.rom)";
                    }
                });
            } else if (n == 2) {
                jFileChooser.setDialogTitle("Select Web Content");
                jFileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File file) {
                        return file.getName().toLowerCase().endsWith(".zip") || file.isDirectory();
                    }

                    public String getDescription() {
                        return "Web Content (.zip)";
                    }
                });
            }
            if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null && !file.isDirectory()) {
                this.fileNames_[n].setText(file.getAbsolutePath());
                this.fileNames_[n].setEnabled(true);
                this.checkBoxes_[n].setSelected(true);
                if (n == 2) {
                    this.tfWebOutPath_.setEnabled(true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showLoadPathDialog() {
        try {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Select Web Content Extraction Path");
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileSelectionMode(1);
            String string = this.tfWebOutPath_.getText();
            if (string.length() > 0) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
            if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.tfWebOutPath_.setText(file.getAbsolutePath());
                this.tfWebOutPath_.setEnabled(true);
                this.checkBoxes_[2].setSelected(true);
                this.fileNames_[2].setEnabled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

